# import yt_dlp
# import os

# def extract_video_info(url):
#     ydl_opts = {
#         'format': 'best',
#         'quiet': True,
#         'no_warnings': True,
#         'outtmpl': 'downloads/%(title)s.%(ext)s',
#     }
    
#     os.makedirs('downloads', exist_ok=True)
    
#     with yt_dlp.YoutubeDL(ydl_opts) as ydl:
#         info = ydl.extract_info(url, download=True)
        
#         title = info.get('title')
#         thumbnail = info.get('thumbnail')
#         ext = info.get('ext')
        
#         filename = ydl.prepare_filename(info)
        
#         return {
#             'download_url': f'/download/{filename}',
#             'title': title,
#             'thumbnail': thumbnail
#         }

# def download_video(url):
#     return extract_video_info(url)

import yt_dlp

def extract_video_info(url):
    ydl_opts = {
        'format': 'best',
        'quiet': True,
        'no_warnings': True,
    }
    
    with yt_dlp.YoutubeDL(ydl_opts) as ydl:
        info = ydl.extract_info(url, download=False)
        
        download_url = info.get('url')
        title = info.get('title')
        thumbnail = info.get('thumbnail')
        
        return {
            'download_url': download_url,
            'title': title,
            'thumbnail': thumbnail
        }